%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%     Minimax Regret in Practice - Four Examples on Treatment Choice    %%
%%                             Matlab Code                               %%
%%              by Patrick Eozenou, Javier Rivas and Karl Schlag         %%
%%                       2006 - Copyrights reserved                      %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%---Function that calls the appropiate function-method given user inputs---

function[probability_of_choosing_treatment_1,probability_of_choosing_treatment_2]...
    = f_program(treatments, treatment_1, treatment_2, lower_interval, upper_interval,...
    method, VA_trick, accuracy, cost_1, cost_2);

nothing = 0;
[nothing] = f_beautiful_things_1(nothing);

[error] = f_error(treatment_1, treatment_2...
    , lower_interval, upper_interval, method, VA_trick, accuracy);

original_lower_interval = lower_interval;
original_upper_interval = upper_interval;
[regret,upper_interval, lower_interval, treatment_1, treatment_2] = f_regret_and_cost(...
    treatment_1, treatment_2, lower_interval, upper_interval, method, VA_trick, ...
    accuracy, cost_1, cost_2);

if error == 0;
  if method == 0 & VA_trick == 0;
    [probability_of_choosing_treatment_1] = f_BAR_without_VR(treatment_1, treatment_2...
    , lower_interval, upper_interval, accuracy);
  elseif method == 0 & VA_trick == 1;
    [probability_of_choosing_treatment_1] = f_BAR_with_VR(treatment_1, treatment_2...
    , lower_interval, upper_interval, accuracy);
  elseif method == 1 & VA_trick == 0;
    [probability_of_choosing_treatment_1] = f_PS_without_VR(treatment_1, treatment_2...
    , lower_interval, upper_interval, accuracy);
  elseif method == 1 & VA_trick == 1;
    [probability_of_choosing_treatment_1] = f_PS_with_VR(treatment_1, treatment_2...
    , lower_interval, upper_interval, accuracy);
  end;
  probability_of_choosing_treatment_2 = 1 - probability_of_choosing_treatment_1;
else;
  probability_of_choosing_treatment_1 = ('NOT AVAILABLE');
  probability_of_choosing_treatment_2 = ('NOT AVAILABLE');
end;

[nothing] = f_beautiful_things_2(treatments, probability_of_choosing_treatment_1, ...
    probability_of_choosing_treatment_2, original_lower_interval, original_upper_interval,...
    method, VA_trick, accuracy, cost_1, cost_2, error, regret);